/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.creativetab;

import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.creativetab.BCLCreativeTab;
import org.betterx.bclib.registry.BaseRegistry;

public class BCLCreativeTabManager {
    public final String modID;
    protected final List<BCLCreativeTab> tabs = new LinkedList<BCLCreativeTab>();

    public static BCLCreativeTabManager create(String modID) {
        return new BCLCreativeTabManager(modID);
    }

    protected BCLCreativeTabManager(String modID) {
        this.modID = modID;
    }

    public BCLCreativeTab.Builder createTab(String name) {
        return new BCLCreativeTab.Builder(this, name);
    }

    public BCLCreativeTab.Builder createBlockTab(ItemLike icon) {
        return new BCLCreativeTab.Builder(this, "blocks").setIcon(icon).setPredicate(BCLCreativeTab.BLOCKS);
    }

    public BCLCreativeTab.Builder createItemsTab(ItemLike icon) {
        return new BCLCreativeTab.Builder(this, "items").setIcon(icon);
    }

    public BCLCreativeTabManager processBCLRegistry() {
        this.process(BaseRegistry.getModItems(this.modID));
        this.process(BaseRegistry.getModBlockItems(this.modID));
        return this;
    }

    public BCLCreativeTabManager process(List<Item> items) {
        block0: for (Item item : items) {
            for (BCLCreativeTab tab : this.tabs) {
                if (!tab.predicate.contains(item)) continue;
                tab.addItem(item);
                continue block0;
            }
        }
        return this;
    }

    public void register() {
        for (BCLCreativeTab tab : this.tabs) {
            CreativeModeTab tabItem = FabricItemGroup.builder().m_257737_(() -> new ItemStack(tab.icon)).m_257941_(tab.title).m_257501_((featureFlagSet, output) -> output.m_246601_(tab.items.stream().map(ItemStack::new).toList())).m_257652_();
            Registry.m_194579_((Registry)BuiltInRegistries.f_279662_, tab.key, (Object)tabItem);
        }
    }
}

